<?php
/**
 * SCL-90 管理后台 Pro+ 深度修复版
 * 修复：$tpl 未定义 Bug、档案空白、原生 Alert 替换为 iOS Toast
 */
require_once 'db_core.php';
require_once 'includes/functions.php';

session_start();

// --- 权限校验 ---
$admin_pass_query = $pdo->query("SELECT value FROM configs WHERE key = 'admin_password'");
$CORRECT_PASSWORD = $admin_pass_query->fetchColumn() ?: 'Abc123456';

if (isset($_GET['logout'])) { session_destroy(); header("Location: admin.php"); exit; }
if (isset($_POST['login_pass'])) {
    if ($_POST['login_pass'] === $CORRECT_PASSWORD) { $_SESSION['admin_auth'] = true; } 
    else { $login_error = "鉴权失败"; }
}

if (!isset($_SESSION['admin_auth'])) {
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <title>系统授权</title>
    <link rel="stylesheet" href="assets/style.css">
    <style>
        body { background:#F2F2F7; height:100vh; display:flex; align-items:center; justify-content:center; }
        .login-card { background:#fff; padding:40px; border-radius:24px; box-shadow:var(--shadow-md); width:340px; text-align:center; }
    </style>
</head>
<body>
    <div class="login-card fade-in">
        <div style="font-size:48px; margin-bottom:20px;">🛡️</div>
        <h2 style="margin-bottom:30px; font-weight:700;">控制中心</h2>
        <form method="POST">
            <input type="password" name="login_pass" placeholder="管理员密码" style="width:100%; padding:14px; border-radius:12px; border:1px solid #d2d2d7; margin-bottom:20px; text-align:center; font-size:16px;">
            <button class="btn-primary" type="submit">授权进入</button>
            <?php if(isset($login_error)) echo "<p style='color:var(--ios-red); font-size:13px; margin-top:10px;'>$login_error</p>"; ?>
        </form>
    </div>
</body>
</html>
<?php exit; }

// --- 核心全局数据提取 (修复 $tpl 未定义问题) ---
$action = $_GET['action'] ?? 'dashboard';
$tpl_query = $pdo->query("SELECT value FROM configs WHERE key='copy_template'");
$tpl = $tpl_query->fetchColumn() ?: "卡密：{CDK}\n链接：{URL}";

// --- 动作处理 ---
if ($action === 'gen') {
    $num = min(100, intval($_POST['num'] ?? 10));
    $stmt = $pdo->prepare("INSERT INTO cdks (code, created_at) VALUES (?, ?)");
    $now = date('Y-m-d H:i:s');
    for ($i=0; $i<$num; $i++) { $stmt->execute([generateRandomCDK(12), $now]); }
    header("Location: admin.php?action=cdk_mgr&msg=1"); exit;
}
if ($action === 'save_config') {
    $stmt = $pdo->prepare("REPLACE INTO configs (key, value) VALUES (?, ?)");
    $stmt->execute(['copy_template', $_POST['copy_template']]);
    if(!empty($_POST['new_pass'])) $stmt->execute(['admin_password', $_POST['new_pass']]);
    header("Location: admin.php?action=settings&msg=1"); exit;
}
if ($action === 'del_cdk') {
    $pdo->prepare("DELETE FROM cdks WHERE id = ?")->execute([$_GET['id']]);
    header("Location: admin.php?action=cdk_mgr&msg=1"); exit;
}

// 统计
$stats = [
    'total' => $pdo->query("SELECT COUNT(*) FROM cdks")->fetchColumn(),
    'used'  => $pdo->query("SELECT COUNT(*) FROM cdks WHERE status = 1")->fetchColumn(),
    'records' => $pdo->query("SELECT COUNT(*) FROM test_results WHERE is_complete = 1")->fetchColumn()
];
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <title>SCL-90 控制台 Pro+</title>
    <link rel="stylesheet" href="assets/style.css">
    <style>
        body { display: flex; background: #F2F2F7; height: 100vh; overflow: hidden; }
        .sidebar { width: 260px; background: rgba(255, 255, 255, 0.75); backdrop-filter: blur(20px); border-right: 0.5px solid var(--ios-divider); padding: 20px; display: flex; flex-direction: column; }
        .sidebar-brand { font-size: 22px; font-weight: 800; padding: 10px; margin-bottom: 30px; color: var(--ios-blue); letter-spacing: -1px; }
        .nav-item { padding: 12px 16px; border-radius: 12px; color: var(--ios-text); text-decoration: none; font-weight: 600; font-size: 15px; margin-bottom: 6px; display: flex; align-items: center; gap: 10px; transition: 0.2s; }
        .nav-item:hover { background: rgba(0,0,0,0.04); }
        .nav-item.active { background: var(--ios-blue); color: #fff; box-shadow: 0 4px 12px rgba(0,122,255,0.2); }
        .main-content { flex: 1; overflow-y: auto; padding: 40px; position: relative; }
        
        /* Toast 样式 */
        #toast { position: fixed; top: 30px; left: 50%; transform: translateX(-50%); background: rgba(0,0,0,0.8); color:#fff; padding: 12px 24px; border-radius: 20px; font-size: 14px; font-weight: 600; z-index: 10000; display: none; backdrop-filter: blur(10px); animation: slideDown 0.3s ease; }
        @keyframes slideDown { from { top: -50px; opacity: 0; } to { top: 30px; opacity: 1; } }
        
        .pro-table { width: 100%; border-collapse: collapse; background: #fff; border-radius: 20px; overflow: hidden; box-shadow: var(--shadow-sm); }
        .pro-table th { background: #F9F9FB; padding: 15px 20px; text-align: left; font-size: 12px; color: var(--ios-subtext); text-transform: uppercase; }
        .pro-table td { padding: 15px 20px; border-top: 0.5px solid var(--ios-divider); }
    </style>
</head>
<body>

    <div id="toast">提示信息</div>

    <div class="sidebar">
        <div class="sidebar-brand">SCL-90 Admin</div>
        <nav>
            <a href="?action=dashboard" class="nav-item <?php echo $action==='dashboard'?'active':''; ?>">📊 总览</a>
            <a href="?action=cdk_mgr" class="nav-item <?php echo $action==='cdk_mgr'?'active':''; ?>">🔑 卡密</a>
            <a href="?action=records" class="nav-item <?php echo $action==='records'?'active':''; ?>">📑 档案</a>
            <a href="?action=settings" class="nav-item <?php echo $action==='settings'?'active':''; ?>">⚙️ 设置</a>
        </nav>
        <div style="flex:1"></div>
        <a href="?logout=1" class="nav-item" style="color:var(--ios-red)">🚪 登出</a>
    </div>

    <div class="main-content">
        <?php if ($action === 'dashboard'): ?>
            <h2 style="margin-bottom:30px;">数据分析</h2>
            <div style="display:grid; grid-template-columns: repeat(3, 1fr); gap:20px;">
                <div class="card" style="text-align:center;">
                    <div style="font-size:32px; font-weight:800; color:var(--ios-blue);"><?php echo $stats['total']; ?></div>
                    <div style="font-size:12px; color:var(--ios-subtext);">总生成</div>
                </div>
                <div class="card" style="text-align:center;">
                    <div style="font-size:32px; font-weight:800; color:var(--ios-orange);"><?php echo $stats['used']; ?></div>
                    <div style="font-size:12px; color:var(--ios-subtext);">已消耗</div>
                </div>
                <div class="card" style="text-align:center;">
                    <div style="font-size:32px; font-weight:800; color:var(--ios-green);"><?php echo $stats['records']; ?></div>
                    <div style="font-size:12px; color:var(--ios-subtext);">完成报告</div>
                </div>
            </div>

        <?php elseif ($action === 'cdk_mgr'): ?>
            <div style="display:flex; justify-content:space-between; align-items:center; margin-bottom:30px;">
                <h2>卡密库 (100条)</h2>
                <button class="btn-primary" style="width:auto; padding:10px 24px;" onclick="toggleModal('genModal')">批量生成</button>
            </div>
            <table class="pro-table">
                <thead><tr><th>卡密</th><th>状态</th><th>创建时间</th><th>操作</th></tr></thead>
                <tbody>
                    <?php 
                    $list = $pdo->query("SELECT * FROM cdks ORDER BY id DESC LIMIT 100")->fetchAll();
                    foreach($list as $c): ?>
                    <tr>
                        <td style="font-family:monospace; font-weight:700;"><?php echo $c['code']; ?></td>
                        <td><?php echo $c['status']?'<span class="badge bg-orange">已用</span>':'<span class="badge bg-green">未使用</span>'; ?></td>
                        <td style="font-size:12px; color:var(--ios-subtext);"><?php echo $c['created_at']; ?></td>
                        <td style="text-align:right;">
                            <?php if(!$c['status']): ?>
                            <button class="btn-sec" style="font-size:11px; padding:6px 12px;" onclick="copyDist('<?php echo $c['code']; ?>')">复制</button>
                            <?php endif; ?>
                            <a href="?action=del_cdk&id=<?php echo $c['id']; ?>" style="color:var(--ios-red); font-size:12px; margin-left:10px;" onclick="return confirm('删除?')">×</a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

        <?php elseif ($action === 'records'): ?>
            <h2 style="margin-bottom:30px;">测试档案</h2>
            <table class="pro-table">
                <thead><tr><th>IP / 时间</th><th>用时</th><th>总均分</th><th>操作</th></tr></thead>
                <tbody>
                    <?php 
                    $recs = $pdo->query("SELECT r.* FROM test_results r WHERE r.is_complete = 1 ORDER BY r.end_time DESC LIMIT 100")->fetchAll();
                    foreach($recs as $r): ?>
                    <tr>
                        <td>
                            <div style="font-weight:700;"><?php echo $r['visitor_ip']; ?></div>
                            <div style="font-size:11px; color:var(--ios-subtext);"><?php echo $r['end_time']; ?></div>
                        </td>
                        <td style="font-size:13px;"><?php echo formatDuration($r['duration']); ?></td>
                        <td style="font-weight:800; color:var(--ios-blue);"><?php echo $r['gsi_score']; ?></td>
                        <td style="text-align:right;">
                            <a href="result.php?admin_record_id=<?php echo $r['id']; ?>" target="_blank" class="btn-sec" style="text-decoration:none; font-size:11px; padding:6px 12px;">查阅卷宗</a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

        <?php elseif ($action === 'settings'): ?>
            <h2>全局设置</h2>
            <div class="card" style="max-width:600px;">
                <form action="?action=save_config" method="POST">
                    <label style="font-size:13px; font-weight:700;">分发模板</label>
                    <textarea name="copy_template" style="width:100%; height:120px; border-radius:12px; border:1px solid #d2d2d7; padding:15px; margin:10px 0; font-size:14px;"><?php echo htmlspecialchars($tpl); ?></textarea>
                    <label style="font-size:13px; font-weight:700;">修改后台密码</label>
                    <input type="password" name="new_pass" placeholder="不改请留空" style="width:100%; padding:14px; border-radius:12px; border:1px solid #d2d2d7; margin:10px 0;">
                    <button class="btn-primary" style="margin-top:10px;">更新设置</button>
                </form>
            </div>
        <?php endif; ?>
    </div>

    <div id="genModal" style="display:none; position:fixed; top:0; left:0; right:0; bottom:0; background:rgba(0,0,0,0.5); z-index:9999; align-items:center; justify-content:center;">
        <div class="card" style="width:320px; text-align:center;">
            <h3 style="margin-bottom:20px;">批量生成卡密</h3>
            <form action="?action=gen" method="POST">
                <input type="number" name="num" value="10" min="1" max="100" style="width:100%; padding:14px; border-radius:12px; border:1px solid #d2d2d7; margin-bottom:20px; text-align:center;">
                <button class="btn-primary" type="submit">开始创建</button>
                <button class="btn-sec" type="button" style="width:100%; margin-top:10px;" onclick="toggleModal('genModal')">取消</button>
            </form>
        </div>
    </div>

<script>
// Toast 通知
function showToast(msg) {
    const t = document.getElementById('toast');
    t.innerText = msg;
    t.style.display = 'block';
    setTimeout(() => { t.style.display = 'none'; }, 2000);
}

// 复制分发链接 (净化 URL)
function copyDist(cdk) {
    const template = `<?php echo str_replace(["\r", "\n"], ["", "\\n"], $tpl); ?>`;
    const cleanBase = window.location.origin + window.location.pathname.replace(/admin\.php$/, 'index.php');
    const text = template.replace('{CDK}', cdk).replace('{URL}', cleanBase);
    
    const el = document.createElement('textarea');
    el.value = text;
    document.body.appendChild(el);
    el.select();
    document.execCommand('copy');
    document.body.removeChild(el);
    showToast('✨ 卡密分发内容已复制');
}

function toggleModal(id) {
    const m = document.getElementById(id);
    m.style.display = (m.style.display === 'none' || m.style.display === '') ? 'flex' : 'none';
}

// 处理 URL 参数消息
const urlParams = new URLSearchParams(window.location.search);
if(urlParams.get('msg')) showToast('✅ 操作成功');
</script>
</body>
</html>