const app = {
    answers: {},
    current: 1,
    total: 90,
    startTime: Date.now(),

    init: function() {
        this.render();
    },

    render: function() {
        const idx = this.current;
        document.getElementById('qIndex').textContent = `${idx} / ${this.total}`;
        document.getElementById('qContent').textContent = `${idx}. ${SCL_DATA.questions[idx-1]}`;
        
        const box = document.getElementById('optionsBox');
        box.innerHTML = '';
        const curVal = this.answers['q'+idx];
        
        SCL_DATA.scale.forEach(opt => {
            const btn = document.createElement('div');
            btn.className = `opt-btn ${curVal === opt.val ? 'selected' : ''}`;
            btn.innerHTML = `<span>${opt.emoji} ${opt.txt}</span>${curVal === opt.val ? '<b>✓</b>' : ''}`;
            btn.onclick = () => this.select(opt.val);
            box.appendChild(btn);
        });

        this.updateProgress();
        document.getElementById('prevBtn').style.visibility = (idx === 1) ? 'hidden' : 'visible';
    },

    select: function(val) {
        this.answers['q' + this.current] = val;
        if (this.current < this.total) {
            this.current++;
            setTimeout(() => this.render(), 150);
        } else {
            this.finish();
        }
    },

    prev: function() {
        if (this.current > 1) {
            this.current--;
            this.render();
        }
    },

    updateProgress: function() {
        const percent = Math.round((Object.keys(this.answers).length / this.total) * 100);
        const circle = document.getElementById('ringCircle');
        const offset = 87.96 * (1 - percent / 100);
        circle.style.strokeDashoffset = offset;
        document.getElementById('ringText').textContent = percent + '%';
    },

    finish: function() {
        if (!confirm('已完成所有题目，确定提交分析吗？')) return;
        
        document.getElementById('quizCard').classList.add('hidden');
        document.getElementById('loadingCard').classList.remove('hidden');

        // 计算各维度得分
        const scores = {};
        let totalSum = 0;
        for (let key in SCL_DATA.dims) {
            let dimSum = 0;
            SCL_DATA.dims[key].items.forEach(qIdx => {
                dimSum += (this.answers['q' + qIdx] || 1);
            });
            scores[key] = (dimSum / SCL_DATA.dims[key].items.length).toFixed(2);
            totalSum += dimSum;
        }

        const gsi = (totalSum / 90).toFixed(2);
        const duration = Math.round((Date.now() - this.startTime) / 1000);

        // 提交数据到后端
        fetch('api.php?action=submit', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({
                gsi: gsi,
                scores: scores,
                duration: duration,
                is_complete: 1
            })
        })
        .then(res => res.json())
        .then(res => {
            if (res.success) {
                location.href = 'result.php';
            } else {
                alert('提交失败：' + res.message);
            }
        });
    },

    reset: function() {
        if(confirm('确定要重置当前答题进度吗？')) location.reload();
    }
};

app.init();