<?php
/**
 * SCL-90 核心数据库文件
 * 逻辑：自动初始化 SQLite 数据库与表结构
 */

// 数据库路径 (存放在根目录，建议实际部署时移动至不可直接访问的目录)
define('DB_PATH', __DIR__ . '/scl90.db');

try {
    // 1. 建立连接
    $pdo = new PDO("sqlite:" . DB_PATH);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);

    // 2. 初始化表结构
    
    // A. 卡密表
    $pdo->exec("CREATE TABLE IF NOT EXISTS cdks (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        code TEXT UNIQUE NOT NULL,          -- 卡密内容
        status INTEGER DEFAULT 0,            -- 0:未使用, 1:已使用
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        used_at DATETIME DEFAULT NULL
    )");

    // B. 测试记录表 (增强证据链)
    $pdo->exec("CREATE TABLE IF NOT EXISTS test_results (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        cdk_id INTEGER,                      -- 关联卡密
        visitor_ip TEXT,                     -- 访问者IP
        visitor_ua TEXT,                     -- 浏览器指纹/设备信息
        start_time DATETIME,                 -- 验证通过时间
        end_time DATETIME,                   -- 提交完成时间
        duration INTEGER,                    -- 答题用时(秒)
        is_complete INTEGER DEFAULT 0,       -- 1:完整答题, 0:未完成
        gsi_score REAL,                      -- 总均分 (GSI)
        score_json TEXT,                     -- 各维度详细得分 (JSON)
        FOREIGN KEY(cdk_id) REFERENCES cdks(id)
    )");

    // C. 配置表 (管理分发文案)
    $pdo->exec("CREATE TABLE IF NOT EXISTS configs (
        key TEXT PRIMARY KEY,
        value TEXT
    )");

    // 3. 初始配置注入 (仅在表为空时)
    $checkConfig = $pdo->query("SELECT COUNT(*) FROM configs")->fetchColumn();
    if ($checkConfig == 0) {
        $defaultTemplate = "亲，久等啦！这是您的深度测评卡密：{CDK}\n请访问：{URL} 进行测试。\n【提示】一码一测，完成后请记得保存结果截图。";
        $stmt = $pdo->prepare("INSERT INTO configs (key, value) VALUES (?, ?)");
        $stmt->execute(['copy_template', $defaultTemplate]);
        $stmt->execute(['admin_password', 'Abc123456']); // 初始后台密码
    }

} catch (PDOException $e) {
    die("数据库连接失败: " . $e->getMessage());
}