<?php
/**
 * SCL-90 核心工具函数
 */

/**
 * 获取访问者真实 IP
 */
function getVisitorIP() {
    $ip = $_SERVER['REMOTE_ADDR'];
    if (isset($_SERVER['HTTP_X_FORWARDED_FOR']) && preg_match('/^\d{1,3}(\.\d{1,3}){3}/', $_SERVER['HTTP_X_FORWARDED_FOR'])) {
        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    } elseif (isset($_SERVER['HTTP_CLIENT_IP']) && preg_match('/^\d{1,3}(\.\d{1,3}){3}/', $_SERVER['HTTP_CLIENT_IP'])) {
        $ip = $_SERVER['HTTP_CLIENT_IP'];
    }
    return $ip;
}

/**
 * 解析卡密分发模板
 */
function parseDistributeTemplate($template, $cdk) {
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https://" : "http://";
    $currentUrl = $protocol . $_SERVER['HTTP_HOST'] . str_replace('admin.php', 'index.php', $_SERVER['PHP_SELF']);
    
    $search = ['{CDK}', '{URL}'];
    $replace = [$cdk, $currentUrl];
    
    return str_replace($search, $replace, $template);
}

/**
 * 生成安全随机卡密
 */
function generateRandomCDK($length = 12) {
    $chars = 'ABCDEFGHJKLMNPQRSTUVWXYZ23456789'; // 排除易混淆字符
    $code = '';
    for ($i = 0; $i < $length; $i++) {
        $code .= $chars[mt_rand(0, strlen($chars) - 1)];
    }
    return $code;
}

/**
 * 格式化答题用时
 */
function formatDuration($seconds) {
    if ($seconds < 60) return $seconds . "秒";
    return floor($seconds / 60) . "分" . ($seconds % 60) . "秒";
}

/**
 * 权限校验：检查是否已经过卡密验证
 */
function checkAuth() {
    session_start();
    if (!isset($_SESSION['auth_cdk_id'])) {
        header("Location: index.php?error=unauthorized");
        exit;
    }
}