<?php
session_start();
// 如果已经验证过，直接跳转到测试页
if (isset($_SESSION['auth_cdk_id'])) {
    header("Location: test.php");
    exit;
}
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no, viewport-fit=cover">
    <title>身份验证 - SCL-90 专业测评</title>
    <link rel="stylesheet" href="assets/style.css">
    <style>
        body { background-color: #F2F2F7; display: flex; align-items: center; justify-content: center; min-height: 100vh; margin: 0; }
        .auth-card { width: 90%; max-width: 400px; background: rgba(255, 255, 255, 0.8); backdrop-filter: blur(20px); border-radius: 24px; padding: 40px 24px; box-shadow: 0 10px 30px rgba(0,0,0,0.05); text-align: center; animation: slideUp 0.6s cubic-bezier(0.23, 1, 0.32, 1); }
        .icon-box { font-size: 64px; margin-bottom: 20px; }
        .title { font-size: 24px; font-weight: 700; color: #1d1d1f; margin-bottom: 8px; }
        .desc { font-size: 15px; color: #86868b; margin-bottom: 32px; line-height: 1.4; }
        .input-group { position: relative; margin-bottom: 20px; }
        .input-group input { width: 100%; padding: 16px; border-radius: 14px; border: 1.5px solid #d2d2d7; font-size: 17px; font-weight: 600; text-align: center; transition: all 0.3s; background: #fff; box-sizing: border-box; }
        .input-group input:focus { border-color: #007AFF; outline: none; box-shadow: 0 0 0 4px rgba(0,122,255,0.1); }
        .btn-verify { width: 100%; padding: 16px; background: #007AFF; color: #fff; border: none; border-radius: 14px; font-size: 17px; font-weight: 600; cursor: pointer; transition: all 0.2s; }
        .btn-verify:active { transform: scale(0.98); opacity: 0.9; }
        .error-tips { color: #FF3B30; font-size: 13px; margin-top: 12px; height: 18px; font-weight: 500; }
        @keyframes slideUp { from { opacity: 0; transform: translateY(20px); } to { opacity: 1; transform: translateY(0); } }
    </style>
</head>
<body>

<div class="auth-card">
    <div class="icon-box">🔐</div>
    <div class="title">身份验证</div>
    <div class="desc">本测评为专业受限版本<br>请输入您的激活卡密以开始测试</div>
    
    <div class="input-group">
        <input type="text" id="cdkInput" placeholder="输入卡密" autocomplete="off" spellcheck="false">
        <div id="errorTips" class="error-tips"></div>
    </div>
    
    <button class="btn-verify" onclick="handleVerify()">验证并开始</button>
    
    <div style="margin-top: 40px; font-size: 12px; color: #C7C7CC;">
        一个卡密仅限使用一次 · 提交后请及时保存结果
    </div>
</div>

<script>
async function handleVerify() {
    const cdk = document.getElementById('cdkInput').value.trim();
    const tips = document.getElementById('errorTips');
    
    if (!cdk) {
        tips.innerText = '请输入卡密';
        return;
    }

    tips.innerText = '正在验证...';
    
    try {
        const response = await fetch('api.php?action=verify', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ code: cdk })
        });
        const result = await response.json();
        
        if (result.success) {
            tips.style.color = '#34C759';
            tips.innerText = '验证成功，正在进入...';
            setTimeout(() => location.href = 'test.php', 800);
        } else {
            tips.style.color = '#FF3B30';
            tips.innerText = result.message || '卡密无效或已被使用';
        }
    } catch (e) {
        tips.innerText = '网络请求失败，请重试';
    }
}
</script>
</body>
</html>