<?php
/**
 * SCL-90 系统一键启动安装程序
 * 功能：检查环境、初始化数据库、验证权限
 */

header('Content-Type: text/html; charset=utf-8');

// 1. 环境检查
$errors = [];
if (version_compare(PHP_VERSION, '7.4.0', '<')) {
    $errors[] = "❌ PHP 版本过低：当前 " . PHP_VERSION . "，建议 7.4 或以上。";
}
if (!extension_loaded('pdo_sqlite')) {
    $errors[] = "❌ 缺失组件：PHP 未开启 pdo_sqlite 扩展（请在 XAMPP 的 php.ini 中开启）。";
}
if (!is_writable(__DIR__)) {
    $errors[] = "❌ 权限错误：当前目录不可写，无法创建数据库文件。";
}

// 2. 尝试执行初始化
$db_init_success = false;
if (empty($errors)) {
    try {
        require_once 'db_core.php';
        $db_init_success = true;
    } catch (Exception $e) {
        $errors[] = "❌ 数据库初始化失败：" . $e->getMessage();
    }
}

?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
    <title>系统启动中心 - SCL-90</title>
    <link rel="stylesheet" href="assets/style.css">
    <style>
        body { background: #F2F2F7; display: flex; align-items: center; justify-content: center; min-height: 100vh; margin: 0; }
        .setup-card { background: #fff; padding: 40px 24px; border-radius: 24px; box-shadow: 0 10px 30px rgba(0,0,0,0.05); width: 90%; max-width: 400px; text-align: center; }
        .status-list { text-align: left; margin: 20px 0; font-size: 14px; background: #F9F9FB; padding: 15px; border-radius: 12px; }
    </style>
</head>
<body>
    <div class="setup-card fade-in">
        <div style="font-size: 50px;">🚀</div>
        <h2 style="margin: 15px 0 5px;">一键启动中心</h2>
        <p style="color: #8E8E93; font-size: 14px;">正在为您准备 SCL-90 测评系统</p>

        <div class="status-list">
            <?php if (empty($errors)): ?>
                <div style="color: #34C759; margin-bottom: 8px;">✅ 环境检测通过</div>
                <div style="color: #34C759;">✅ 数据库已就绪 (scl90.db)</div>
            <?php else: ?>
                <?php foreach ($errors as $err) echo "<div style='color:#FF3B30; margin-bottom:8px;'>$err</div>"; ?>
            <?php endif; ?>
        </div>

        <?php if (empty($errors) && $db_init_success): ?>
            <button class="btn-primary" onclick="location.href='admin.php'">进入后台管理</button>
            <p style="font-size: 12px; color: #C7C7CC; margin-top: 15px;">默认后台密码：Abc123456</p>
        <?php else: ?>
            <button class="btn-primary" style="background:#8E8E93;" onclick="location.reload()">重新检查</button>
        <?php endif; ?>
    </div>
</body>
</html>