<?php
require_once 'includes/functions.php';
// 权限校验：未经验证无法进入
checkAuth();
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no, viewport-fit=cover">
    <title>SCL-90 专业心理测评</title>
    <link rel="stylesheet" href="assets/style.css">
</head>
<body>

<div class="app-container">
    <div class="navbar">
        <div class="nav-title">SCL-90 专业版</div>
        <div class="ring-container" id="progressRing">
            <svg class="ring-svg" width="32" height="32">
                <circle stroke="#E5E5EA" stroke-width="3" fill="transparent" r="14" cx="16" cy="16" />
                <circle id="ringCircle" stroke="#007AFF" stroke-width="3" fill="transparent" r="14" cx="16" cy="16" stroke-dasharray="87.96" stroke-dashoffset="87.96" stroke-linecap="round" />
            </svg>
            <div class="ring-text" id="ringText">0%</div>
        </div>
    </div>

    <div class="content">
        <div id="quizCard" class="card fade-in">
            <div class="q-meta">
                <span>标准症状自评</span>
                <span id="qIndex">1 / 90</span>
            </div>
            <div class="q-text" id="qContent">正在加载题目...</div>
            <div class="options-grid" id="optionsBox"></div>
            <div class="toolbar">
                <button class="btn-sec" id="prevBtn" onclick="app.prev()">上一题</button>
                <div style="flex:1"></div>
                <button class="btn-sec" style="color:var(--ios-red); flex:none;" onclick="app.reset()">重置进度</button>
            </div>
        </div>
        
        <div id="loadingCard" class="card hidden" style="text-align:center; padding:60px 20px;">
            <div class="spinner"></div>
            <div style="margin-top:20px; color:var(--ios-subtext);">正在生成深度画像分析报告...</div>
        </div>
    </div>
</div>

<script src="assets/questions.js"></script>
<script src="assets/app.js"></script>
</body>
</html>